/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5632;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class BlackboardManager {
    private static final LoadingCache<Key, Blackboard> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        Blackboard value = (Blackboard)i.getValue();
        if (value != null) {
            RenderSystem.recordRenderCall(value::close);
        }
    }).build((CacheLoader)new CacheLoader<Key, Blackboard>(){

        public Blackboard load(Key key) {
            return null;
        }
    });

    public static Blackboard getInstance(Key key) {
        Blackboard textureInstance = (Blackboard)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new Blackboard(BlackboardBlockTile.unpackPixels(key.values), key.glow);
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    public static class Blackboard
    implements AutoCloseable {
        private static final int WIDTH = 16;
        private final Map<class_2350, List<class_777>> quadsCache = new EnumMap<class_2350, List<class_777>>(class_2350.class);
        private final byte[][] pixels;
        private final boolean glow;
        @Nullable
        private class_1043 texture;
        @Nullable
        private class_1921 renderType;
        @Nullable
        private class_2960 textureLocation;

        private Blackboard(byte[][] pixels, boolean glow) {
            this.pixels = pixels;
            this.glow = glow;
        }

        public byte[][] getPixels() {
            return this.pixels;
        }

        public boolean isGlow() {
            return this.glow;
        }

        private void initializeTexture() {
            this.texture = new class_1043(16, 16, false);
            for (int y = 0; y < this.pixels.length && y < 16; ++y) {
                for (int x = 0; x < this.pixels[y].length && x < 16; ++x) {
                    this.texture.method_4525().method_4305(x, y, Blackboard.getColoredPixel(this.pixels[x][y], x, y));
                }
            }
            this.texture.method_4524();
            this.textureLocation = class_310.method_1551().method_1531().method_4617("blackboard/", this.texture);
            this.renderType = class_1921.method_23572((class_2960)this.textureLocation);
        }

        private static int getColoredPixel(byte i, int x, int y) {
            int offset = i > 0 ? 16 : 0;
            int tint = BlackboardBlock.colorFromByte(i);
            class_1059 textureMap = class_310.method_1551().method_1554().method_24153(class_1059.field_5275);
            class_1058 sprite = textureMap.method_4608(ModTextures.BLACKBOARD_TEXTURE);
            return Blackboard.getTintedColor(sprite, x, y, offset, tint);
        }

        private static int getTintedColor(class_1058 sprite, int x, int y, int offset, int tint) {
            if (sprite == null || sprite.method_4592() == 0) {
                return -1;
            }
            int tintR = tint >> 16 & 0xFF;
            int tintG = tint >> 8 & 0xFF;
            int tintB = tint & 0xFF;
            int pixel = ClientPlatformHelper.getPixelRGBA((class_1058)sprite, (int)0, (int)Math.min(sprite.method_4578() - 1, x + offset), (int)Math.min(sprite.method_4595() - 1, y));
            int totalB = pixel >> 16 & 0xFF;
            int totalG = pixel >> 8 & 0xFF;
            int totalR = pixel & 0xFF;
            return class_1011.method_24031((int)255, (int)(totalB * tintB / 255), (int)(totalG * tintG / 255), (int)(totalR * tintR / 255));
        }

        @Nonnull
        public List<class_777> getOrCreateModel(class_2350 dir, BiFunction<Blackboard, class_2350, List<class_777>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (class_2350)d));
        }

        @Nonnull
        public class_2960 getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nonnull
        public class_1921 getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                class_310.method_1551().method_1531().method_4615(this.textureLocation);
            }
        }
    }

    public static class Key
    implements class_5632 {
        private final long[] values;
        private final boolean glow;

        Key(long[] packed, boolean glowing) {
            this.values = packed;
            this.glow = glowing;
        }

        public static Key of(long[] packPixels, boolean glowing) {
            return new Key(packPixels, glowing);
        }

        public static Key of(long[] packPixels) {
            return new Key(packPixels, false);
        }

        public boolean equals(Object another) {
            if (another == this) {
                return true;
            }
            if (another == null) {
                return false;
            }
            if (another.getClass() != this.getClass()) {
                return false;
            }
            Key key = (Key)another;
            return Arrays.equals(this.values, key.values) && this.glow == key.glow;
        }

        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

